// An extremely sneaky sketch that hijacks another sketch
// and tracks its use of hierarchical modelling functions.
// Scroll down to the comments below draw() to see where 
// you should paste the source code for a sketch.  Your sketch
// should only use rect(), triangle() and ellipse(), together
// with pushMatrix(), popMatrix(), scale(), rotate(), and 
// translate(). It should do its drawing in draw(), not in 
// setup().

// This is a very advanced sketch -- hijacking basic Processing
// features is well beyond the scope of this course.  So don't
// worry about trying to understand what I'm doing here.  I
// wanted to share it so that you can try to use it to help
// understand hierarchical modelling.

// Star the sketch, and press the spacebar to advance through
// the steps in the drawing.

import java.util.Vector;

class Context
{
  public Vector<String> lines;
  public Context()
  {
    lines = new Vector<String>();
  }

  public void add( String msg )
  {
    lines.add( msg );
  }
}

int sketch_w;
int sketch_h;
Vector<Context> contexts;
String cur_shape;
int pushes;

int max_cmds;
int cur_cmd;

PFont fnt;
int points = 20;
int swidth = 400;

void declareCommand()
{
  if ( cur_cmd >= max_cmds ) {
    // Throw an exception to escape drawing.
    throw new Error( "whatever" );
  }
  ++cur_cmd;
}

void pushMatrix()
{
  contexts.add( new Context() );
  declareCommand();
  ++pushes;
  super.pushMatrix();
}

void popMatrix()
{
  contexts.removeElementAt( contexts.size() - 1 );
  declareCommand();
  --pushes;
  super.popMatrix();
}

void applyTransform( String msg )
{
  contexts.lastElement().add( msg );
  declareCommand();
}

void applyShape( String msg )
{
  cur_shape = msg;
  declareCommand();
  cur_shape = null;
}

public void translate( float a, float b )
{
  applyTransform( "translate( " + a + ", " + b + " );" );
  super.translate( a, b );
}

public void rotate( float a )
{
  applyTransform( "rotate( " + a + " );" );
  super.rotate( a );
}

public void scale( float a )
{
  applyTransform( "scale( " + a + " );" );
  super.scale( a );
}

public void scale( float a, float b )
{
  applyTransform( "scale( " + a + ", " + b + " );" );
  super.scale( a, b );
}

public void rect( float a, float b, float c, float d )
{
  applyShape( "rect( " + a + ", " + b + ", " + c + ", " + d + " );" );
  super.rect( a, b, c, d );
}

public void triangle( float a, float b, float c, float d, float e, float f )
{
  applyShape( "triangle( " + a + ", " + b + ", " + c + ", " + d + ", " + e + ", " + f + " );" );
  super.triangle( a, b, c, d, e, f );
}

public void ellipse( float a, float b, float c, float d )
{
  applyShape( "ellipse( " + a + ", " + b + ", " + c + ", " + d + " );" );
  super.ellipse( a, b, c, d );
}

public void background( color c )
{
  pushStyle();
  fill( c );
  noStroke();
  super.rect( 0, 0, sketch_w, sketch_h );
  popStyle();
}

void setup()
{
  setup_csk();
  surface.setSize( 75 + swidth + sketch_w, 50 + sketch_h );
  max_cmds = 0;
  cur_cmd = 0;
  contexts = new Vector<Context>();

  fnt = createFont( "Gotham", points );
  textFont( fnt );
}

void size( int w, int h )
{
  sketch_w = w;
  sketch_h = h;
}

void drawContexts()
{
  int xx = 35;
  int cur_y = height - 35;

  pushStyle();
  for ( Context c : contexts ) {
    int num_msgs = c.lines.size();
    super.fill( 255 );
    super.stroke( 0.0 );
    int h = max( num_msgs*(points+10), 20 );
    //  println( "super.rect( " + xx + ", " + (cur_y - h) + ", 400, " + h + " );" );
    super.rect( xx, cur_y - h, swidth-20, h );

    fill( 0 );
    for ( int idx = 0; idx < c.lines.size (); ++idx ) {
      text( c.lines.get( idx ), xx + 5, cur_y - idx*(points+10) - 5 );
    }

    cur_y -= (h + 10);
  }

  if ( cur_shape != null ) {
    super.fill( 255 );
    super.stroke( 0.0 );
    int h = points+10;
    super.rect( xx, cur_y - h, swidth-20, h );

    fill( 0, 100, 0 );
    text( cur_shape, xx + 5, cur_y - 5 );
  }

  popStyle();
}

void draw()
{ 
  contexts.clear();

  // Don't use background here.
  fill( 80 );
  super.rect( 0, 0, width, height );
  fill( 200 );
  super.rect( 25, 25, swidth, height-50 );
  pushStyle();
  noFill();
  stroke( 0 );
  strokeWeight( 5 );
  line( 25+0.5*swidth-20, 75, 25+0.5*swidth-20, height - 100 );
  line( 25+0.5*swidth+20, 75, 25+0.5*swidth+20, height - 100 ); 
  line( 25+0.5*swidth-40, height - 100 - 20, 25+0.5*swidth, height - 100 + 20 ); 
  line( 25+0.5*swidth+40, height - 100 - 20, 25+0.5*swidth, height - 100 + 20 ); 

  popStyle();

  cur_cmd = 0;

  super.pushMatrix();
  super.clip( 450, 25, sketch_w, sketch_h );
  super.translate( 450, 25 );

  try {
    draw_csk();
  } 
  catch( Error e ) {
  }

  while ( pushes > 0 ) {
    super.popMatrix();
    --pushes;
  }

  super.popMatrix();
  noClip();
  drawContexts();
}

void keyPressed()
{
  ++max_cmds;
}

//=====================================================
// Paste your sketch here.  Replace "draw" with "draw_csk"
// and "setup" with "setup_csk".  Just about everything else
// can probably be left as-is.

void doorknob()
{
  fill( 140 );
  ellipse( 0, 0, 100, 100 );
  fill( 80 );
  ellipse( 0, 0, 50, 50 );
}

void door()
{
  fill( #553A03 );
  rect( -25, -50, 50, 100 );
  fill( #714D05 );
  rect( -20, -45, 40, 40 );
  rect( -20, 5, 40, 40 );

  pushMatrix();
  translate( 20, 0 );
  scale( 0.1 );
  doorknob();
  popMatrix();
}

void window()
{
  fill( #553A03 );
  rect( -25, -30, 50, 60 );
  fill( #FFF97E );
  rect( -20, -25, 40, 50 );
  fill( 100 );
  rect( -20, -25, 40, 30 );
  line( 0, 5, 0, 15 );
  fill( 0 );
  ellipse( 0, 15, 4, 4 );
}

void house()
{
  fill( #D6CEA0 );
  rect( -100, -150, 200, 150 );
  fill( #676558 );
  triangle( 0, -200, -120, -150, 120, -150 );

  pushMatrix();
  scale( 0.5 );
  translate( -25, -50 );
  door();
  popMatrix();
  pushMatrix();
  scale( 0.5 );
  scale( -1, 1 );
  translate( -25, -50 );
  door();
  popMatrix();

  pushMatrix();
  translate( -60, -100 );
  for ( int idx = 0; idx < 3; ++idx ) {
    window();
    translate( 60, 0 );
  }
  popMatrix();
}

void setup_csk()
{
  size( 800, 600 );
}

void draw_csk()
{
  background( #1a1548 );
  stroke( 0 );
  strokeWeight( 1.0 );

  pushMatrix();
  translate( 100, 400 );
  scale( 0.3, 0.3 );

  for ( int idx = 0; idx < 6; ++idx ) {
    house();
    translate( 270, 0 );
  }
  popMatrix();
  
  fill( 180 );
  rect( 0, 400, width, height-400 );
}